/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.OracleOpaque;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.ReplayLoggerFactory;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={OracleOpaque.class, oracle.jdbc.internal.OracleOpaque.class})
public abstract class NonTxnReplayableOpaque
extends NonTxnReplayableBase
implements Replayable {
    private static final String OPAQUE_FEATURE_LOGGER_NAME = "oracle.jdbc.internal.replay.NonTxnReplayableOpaque";
    private static Logger OPAQUE_REPLAY_LOGGER = null;

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        if (object instanceof NonTxnReplayableBase) {
            NonTxnReplayableBase nonTxnReplayableBase = (NonTxnReplayableBase)object;
            nonTxnReplayableBase.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(method, object);
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getJavaSqlConnection() {
        return (Connection)((Object)this.getFailoverManager().getConnectionProxy());
    }

    static {
        if (OPAQUE_REPLAY_LOGGER == null) {
            OPAQUE_REPLAY_LOGGER = ReplayLoggerFactory.getLogger(OPAQUE_FEATURE_LOGGER_NAME);
        }
    }
}

